/*****************************************************
This program was produced by the
CodeWizardAVR V2.05.0 Professional
Automatic Program Generator
 Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project :
Version :
Date    : 17.12.2012
Author  : NeVaDa
Company :
Comments:


Chip type               : ATmega32
Program type            : Application
AVR Core Clock frequency: 16,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 512
*****************************************************/

#include <mega32.h>
#include <delay.h>

// 1 Wire Bus functions
#asm
   .equ __wl_port=0x1B //   PORTA
   .equ __wl_bit=0     // 0
#endasm
// 1 Wire Bus interface functions
#include <1wire.h>

// DS1820 Temperature Sensor functions
#include <ds18b20.h>

#asm
   .equ __lcd_port=0x15 ;PORTC
#endasm
// Alphanumeric LCD Module functions
#include <alcd.h>

// DS1302 Real Time Clock functions
#asm
   .equ __ds1302_port=0x1B ;PORTA
   .equ __ds1302_io=1
   .equ __ds1302_sclk=2
   .equ __ds1302_rst=3
#endasm
#include <ds1302.h>

// Standard Input/Output functions
#include <stdio.h>

// maximum number of DS1820 devices
// connected to the 1 Wire bus
#define btn_m PIND.2
#define btn_minus PIND.4
#define btn_plus PIND.3
#define btn_ok PIND.5
#define led PORTB.0
#define led_error PORTB.1
#define MAX_DS18B20 8
unsigned char ds18b20_devices;
unsigned char ds18b20_rom_codes[MAX_DS18B20][9];
float temper;
int temper_int,temp_out;
char lcd_buffer[80];  // 
unsigned int t;//  
unsigned char hour,h,minut,m,sek,s; //, , 
unsigned char day,d,month,mo,year,y; //, , 
 unsigned char menu,n; //
unsigned int slaid=100; //

void temperature(void) //     -
{
temper=ds18b20_temperature(&ds18b20_rom_codes[0][0]);
temper_int=temper;
           if( temper > 1000 )
            {
             temper = 40960-  temper;
             temper = -temper;
            }
      if(temper<125&&temper>-50){ temp_out=temper;}
}

 void time()
 {
   rtc_get_time(&hour,&minut,&sek); // 
   h=hour;
   m=minut;
   s=sek;
 }

  void date()
 {
   rtc_get_date(&day,&month,&year); // 
   d=day;
   mo=month;
   y=year;
 }

 void lcd()
 {
  lcd_clear();   //  LCD
    if(menu==0)
    {
     lcd_gotoxy(0,0);
         sprintf(lcd_buffer,"%i>%i>%i", d,mo,y);
     lcd_puts(lcd_buffer);  //    
     lcd_gotoxy(4,1);              //
         sprintf(lcd_buffer,"%i:%i:%i", h,m,s);
     lcd_puts(lcd_buffer);  //    

           lcd_gotoxy(9,0);              //
        sprintf(lcd_buffer,"T=%d\xdfC",temp_out);  // 
        lcd_puts(lcd_buffer);  //    
     }
     if(menu==1)
     {
         lcd_gotoxy(5,0);
         sprintf(lcd_buffer,"SET");
     lcd_puts(lcd_buffer);  //    
     lcd_gotoxy(3,1);              //
         sprintf(lcd_buffer,"TERMINAL");
     lcd_puts(lcd_buffer);  //    
     delay_ms(500);
     }
     if(menu==2)
     {
       if(n==0){ sprintf(lcd_buffer,"SET HOUR");}  // 
        if(n==1){ sprintf(lcd_buffer,"SET MINUT");}  // 
         if(n==2){ sprintf(lcd_buffer,"SET SEKUND");}  // 
        lcd_puts(lcd_buffer);  //    
         lcd_gotoxy(4,1);              //
      sprintf(lcd_buffer,"%i:%i:%i", hour,minut,sek);
     lcd_puts(lcd_buffer);  //    
     delay_ms(50);
     }
         if(menu==3)
     {
       if(n==0){ sprintf(lcd_buffer,"SET DAY");}  // 
        if(n==1){ sprintf(lcd_buffer,"SET MONTH");}  // 
         if(n==2){ sprintf(lcd_buffer,"SET YEAR");}  // 
        lcd_puts(lcd_buffer);  //    
         lcd_gotoxy(4,1);              //
      sprintf(lcd_buffer,"%i:%i:%i", day,month,year);
     lcd_puts(lcd_buffer);  //    
     delay_ms(50);
     }
              if(menu==4)
     {
          sprintf(lcd_buffer,"LED DISPLAY");  // 
        lcd_puts(lcd_buffer);  //    
         lcd_gotoxy(4,1);              //
      sprintf(lcd_buffer,"Time: %i",slaid/100);
     lcd_puts(lcd_buffer);  //    
     delay_ms(50);
     }
     if(menu==5)
     {
        sprintf(lcd_buffer,"Press ok for    check display");  // 
        lcd_puts(lcd_buffer);  //    

     delay_ms(50);
     }
 }

 void btn()
 {
  if(btn_m==0&&menu==0){menu=1;}
  if(menu==1){if(btn_m!=0){menu=2;}}
  if(btn_m==0&&menu!=0&&menu!=1){delay_ms(100);menu++;}
  if(menu>=6){menu=0;}
  if(btn_ok==0){delay_ms(10);n++;}
  if(n>=3){n=0;}

  if(menu==2)
  {
   if(n==0)
   {
    if(btn_plus==0){delay_ms(20);hour++;}
    if(btn_minus==0){delay_ms(20);hour--;}
    if(hour>=24){hour=0;}
   }
      if(n==1)
   {
    if(btn_plus==0){delay_ms(20);minut++;}
    if(btn_minus==0){delay_ms(20);minut--;}
    if(minut>=60){minut=0;}
   }
       if(n==2)
   {
    if(btn_plus==0){delay_ms(20);sek++;}
    if(btn_minus==0){delay_ms(20);sek--;}
    if(sek>=60){sek=0;}
   }
   rtc_set_time(hour,minut,sek); // : , , 
  }

   if(menu==3)
  {
   if(n==0)
   {
    if(btn_plus==0){delay_ms(20);day++;}
    if(btn_minus==0){delay_ms(10);day--;}
    if(day>=32){day=1;}
   }
      if(n==1)
   {
    if(btn_plus==0){delay_ms(20);month++;}
    if(btn_minus==0){delay_ms(20);month--;}
    if(month>=13){month=1;}
   }
       if(n==2)
   {
    if(btn_plus==0){delay_ms(20);year++;}
    if(btn_minus==0){delay_ms(20);year--;}
   }
   rtc_set_date(day,month,year); // date
  }
   if(menu==4)
  {

    if(btn_plus==0){delay_ms(20);slaid=slaid+100;}
    if(btn_minus==0){delay_ms(20);slaid=slaid-100;}
    if(slaid>=1000||slaid<100){slaid=100;}

  }
     if(menu==5)
  {

    if(btn_ok==0)
    {
    delay_ms(20);
         lcd_clear();   //  LCD
        sprintf(lcd_buffer,"Display check   is started");  // 
        lcd_puts(lcd_buffer);  //    
        delay_ms(200);
        printf(""); //  
        delay_ms(200);
    menu=0;
    }

  }
 }

 void out_usart()
 {
     led=UCSRA.6;
     led_error=UCSRA.4;
       if(t<slaid) {printf(" -181.");} //  
     led=UCSRA.6;
       if(t>=slaid&&t<slaid*2)
        {
         printf("  %i`C.",temp_out); //   
         }
     led=UCSRA.6;
       if(t>=slaid*2&&t<slaid*3)
        {
        printf(" %i:%i:%i.", h,m,s);
        delay_ms(20);
        printf(" %i %i %i.", h,m,s);
        delay_ms(20);
        printf(" %i:%i:%i.", h,m,s);
        } //   
     led=UCSRA.6;
       if(t>=slaid*3&&t<slaid*4)
       {
       printf(" %i>%i>%i.", d,mo,y);
       } //   
     led=UCSRA.6;
       if(t>=slaid*4)t=0;
 }
// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
 {
  t++;
 }

// Declare your global variables here

void main(void)
{
// Declare your local variables here

// Input/Output Ports initialization
// Port A initialization
// Func7=Out Func6=Out Func5=Out Func4=In Func3=In Func2=In Func1=In Func0=In
// State7=0 State6=0 State5=0 State4=P State3=P State2=P State1=P State0=T
PORTA=0x1E;
DDRA=0xE0;

// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=Out Func1=Out Func0=Out
// State7=T State6=T State5=T State4=T State3=0 State2=0 State1=0 State0=0
PORTB=0x00;
DDRB=0x0F;

// Port C initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
PORTC=0x00;
DDRC=0xFF;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
// State7=P State6=P State5=P State4=P State3=P State2=P State1=T State0=T
PORTD=0xFC;
DDRD=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 15,625 kHz
// Mode: Normal top=0xFF
// OC0 output: Disconnected
TCCR0=0x05;
TCNT0=0x00;
OCR0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer1 Stopped
// Mode: Normal top=0xFFFF
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer2 Stopped
// Mode: Normal top=0xFF
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// INT2: Off
MCUCR=0x00;
MCUCSR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x01;

// USART initialization
// Communication Parameters: 8 Data, 1 Stop, No Parity
// USART Receiver: On
// USART Transmitter: On
// USART Mode: Asynchronous
// USART Baud Rate: 9600
UCSRA=0x00;
UCSRB=0x18;
UCSRC=0x86;
UBRRH=0x00;
UBRRL=0x67;
        UCSRB.4=0;
// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC disabled
ADCSRA=0x00;

// SPI initialization
// SPI disabled
SPCR=0x00;

// TWI initialization
// TWI disabled
TWCR=0x00;

// DS1302 Real Time Clock initialization
// Trickle charger: On
// Trickle charge resistor: 2K
// Trickle charge diode(s): 2
rtc_init(1,2,1);

// 1 Wire Bus initialization
// 1 Wire Data port: PORTA
// 1 Wire Data bit: 0
// Note: 1 Wire port settings must be specified in the
// Project|Configure|C Compiler|Libraries|1 Wire IDE menu.
//w1_init();
ds18b20_devices=w1_search(0xf0,ds18b20_rom_codes);
ds18b20_init(0,-35,35,DS18B20_12BIT_RES);  //    12  
// Alphanumeric LCD initialization
// Connections specified in the
// Project|Configure|C Compiler|Libraries|Alphanumeric LCD menu:
// RS - PORTC Bit 0
// RD - PORTC Bit 1
// EN - PORTC Bit 2
// D4 - PORTC Bit 3
// D5 - PORTC Bit 4
// D6 - PORTC Bit 5
// D7 - PORTC Bit 6
// Characters/line: 16
lcd_init(16);

// Global enable interrupts
#asm("sei")

while (1)
      {
        btn();
       if(menu==0)
       {
        time(); //   
        date(); //   
        temperature(); //   
        }
        delay_ms(5);
        out_usart();
        lcd();
        };

}
